/*
 * Decompiled with CFR 0.152.
 */
package com.primetoxinz.coralreef;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.primetoxinz.coralreef.blocks.CoralBlock;
import com.primetoxinz.coralreef.blocks.GrowableCoralBlock;
import com.primetoxinz.coralreef.worldgen.ReefBaseFeature;
import com.primetoxinz.coralreef.worldgen.ReefRockFeature;
import dev.architectury.hooks.level.biome.GenerationProperties;
import dev.architectury.registry.level.biome.BiomeModifications;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2963;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5450;
import net.minecraft.class_5458;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6577;
import net.minecraft.class_6646;
import net.minecraft.class_6792;
import net.minecraft.class_6793;
import net.minecraft.class_6796;
import net.minecraft.class_6817;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7400;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CoralReef {
    public static final String MOD_ID = "coralreef";
    private static final Logger LOGGER = LogManager.getLogger();
    public static final DeferredRegister<class_1792> ITEMS = DeferredRegister.create((String)"coralreef", (class_5321)class_2378.field_25108);
    public static final DeferredRegister<class_2248> BLOCKS = DeferredRegister.create((String)"coralreef", (class_5321)class_2378.field_25105);
    public static final DeferredRegister<class_3031<?>> FEATURES = DeferredRegister.create((String)"coralreef", (class_5321)class_2378.field_25112);
    public static final RegistrySupplier<class_2248> REEF1_BLOCK = BLOCKS.register("reef1", () -> new class_2248(class_4970.class_2251.method_9639((class_3614)class_3614.field_15914, (class_3620)class_3620.field_16010).method_29292().method_9629(1.5f, 6.0f).method_9626(class_2498.field_11544)));
    public static final RegistrySupplier<class_2248> REEF2_BLOCK = BLOCKS.register("reef2", () -> new class_2248(class_4970.class_2251.method_9639((class_3614)class_3614.field_15914, (class_3620)class_3620.field_16010).method_29292().method_9629(1.5f, 6.0f).method_9626(class_2498.field_11544)));
    public static final class_6862<class_2248> REEF_BASE_BLOCK_TAG = class_6862.method_40092((class_5321)class_2378.field_25105, (class_2960)new class_2960("coralreef", "reef_base_blocks"));
    public static final class_6862<class_2248> REEF_CORAL_TAG = class_6862.method_40092((class_5321)class_2378.field_25105, (class_2960)new class_2960("coralreef", "reef_coral"));
    public static final class_6862<class_1959> HAS_REEF = class_6862.method_40092((class_5321)class_2378.field_25114, (class_2960)new class_2960("coralreef", "has_reef"));
    public static final RegistrySupplier<class_3031<class_6577>> REEF_BASE = FEATURES.register("reef_base", () -> new ReefBaseFeature((Codec<class_6577>)class_6577.field_34698));
    public static final RegistrySupplier<class_3031<class_2963>> REEF_ROCK = FEATURES.register("reef_rock", () -> new ReefRockFeature((Codec<class_2963>)class_2963.field_24874));
    public static List<RegistrySupplier<class_2248>> CORALS = Lists.newArrayList();

    public static void init() {
        int lightLevel = 15;
        ArrayList corals = Lists.newArrayList((Object[])new Coral[]{new Coral("orange", class_3620.field_15987, 1), new Coral("magenta", class_3620.field_15998, 1), new Coral("pink", class_3620.field_16030, 1), new Coral("cyan", class_3620.field_16026, 1), new Coral("lime", class_3620.field_15997, 3), new Coral("brown", class_3620.field_15977, 3)});
        for (Coral coral : corals) {
            String name = coral.name();
            class_3620 materialColor = coral.materialColor();
            class_4970.class_2251 behavior = class_4970.class_2251.method_9639((class_3614)class_3614.field_15947, (class_3620)materialColor).method_9631(value -> 15).method_9634().method_9618().method_9626(class_2498.field_11534);
            Supplier<class_2248> blockSupplier = coral.maxHeight() > 1 ? () -> new GrowableCoralBlock(coral.maxHeight(), behavior) : () -> new CoralBlock(behavior);
            RegistrySupplier block = BLOCKS.register(name, blockSupplier);
            CORALS.add((RegistrySupplier<class_2248>)block);
            ITEMS.register(name, () -> new class_1747((class_2248)block.get(), new class_1792.class_1793().method_7892(class_1761.field_7931)));
        }
        ITEMS.register("reef1", () -> new class_1747((class_2248)REEF1_BLOCK.get(), new class_1792.class_1793().method_7892(class_1761.field_7931)));
        ITEMS.register("reef2", () -> new class_1747((class_2248)REEF2_BLOCK.get(), new class_1792.class_1793().method_7892(class_1761.field_7931)));
        BLOCKS.register();
        ITEMS.register();
        FEATURES.register();
    }

    public static void postInit() {
        class_6880 reefDisk = class_5458.method_40360((class_2378)class_5458.field_25929, (String)"reef_disk", (Object)new class_2975((class_3031)REEF_BASE.get(), (class_3037)new class_6577(class_7400.method_43312((class_2248)((class_2248)REEF1_BLOCK.get())), class_6646.method_39910(List.of(class_2246.field_10566, class_2246.field_10219, class_2246.field_10102, class_2246.field_10255)), (class_6017)class_6019.method_35017((int)2, (int)3), 1)));
        class_6880 reefRock = class_5458.method_40360((class_2378)class_5458.field_25929, (String)"reef_rock", (Object)new class_2975((class_3031)REEF_ROCK.get(), (class_3037)new class_2963(((class_2248)REEF2_BLOCK.get()).method_9564())));
        class_6880 reefPlaced = class_5458.method_40360((class_2378)class_5458.field_35761, (String)"reef", (Object)new class_6796(reefDisk, (List)ImmutableList.of((Object)class_5450.method_39639(), (Object)class_6817.field_36079, (Object)class_6792.method_39614())));
        class_6880 reefRockPlaced = class_5458.method_40360((class_2378)class_5458.field_35761, (String)"reef_rock", (Object)new class_6796(reefRock, (List)ImmutableList.of((Object)class_6793.method_39623((int)2), (Object)class_5450.method_39639(), (Object)class_6817.field_36078, (Object)class_6792.method_39614())));
        BiomeModifications.addProperties(biomeContext -> biomeContext.hasTag(HAS_REEF), (biomeContext, mutable) -> {
            GenerationProperties.Mutable mut = mutable.getGenerationProperties();
            mut.addFeature(class_2893.class_2895.field_13179, reefPlaced);
            mut.addFeature(class_2893.class_2895.field_13171, reefRockPlaced);
        });
    }

    record Coral(String name, class_3620 materialColor, int maxHeight) {
        private final String name;

        public String name() {
            return "coral_" + this.name;
        }
    }
}

